clear

figure('Position', [450 80 1000 900])

% p = uipanel('Position',[.1 .0 .9 .9],'BorderType', 'none');
t = tiledlayout(5,5);
t.TileSpacing = 'none';
t.Padding = 'none';
title(t, 'Crank Phasing [deg]', 'FontWeight', 'Bold', 'FontSize', 12)
ylabel(t, {'';'';'';''}, 'FontWeight', 'Bold', 'FontSize', 12)

Phase = 0:5:20;
ExPortH = 0.075:0.0125:0.225;
InPortH = 0.05:0.0125:0.2;

load('Data.mat')

Data(1,:) = DR;
Data(2,:) = TR;
Data(3,:) = CE;
Data(4,:) = SE;
Data(5,:) = DeltaP;

ContourLevels = struct('data',{[1 1.02 1.05 1.1:0.1:1.6];[0.6:0.1:0.9 0.95 0.97 0.99 1];(0.98:0.01:1.1);(0.8:0.025:0.95);[0:0.05:0.1 0.2:0.2:0.6];});

c = flipud(turbo(1000));


for j = 1:5
    Mat(:,:,:) = reshape(Data(j,:),13,13,5);
    for i = 1:5
        nexttile(t)
        contourf(ExPortH,InPortH,Mat(:,:,i), ContourLevels(j).data, 'ShowText', 'on', 'LineColor', [0.2 0.2 0.2]);
        colormap(gca, c(250:750,:))
        caxis([ContourLevels(j).data(1) ContourLevels(j).data(end)])
%         [c,h] = contourf(ExPortH,InPortH,Mat(:,:,i), 'LineColor', [0.2 0.2 0.2]);
%         clabel(c,h,'LabelSpacing',1000,'FontSize', 9);
%         colormap(gca, flipud(turbo))
%         caxis([-0.5 2])
        set(gca, 'FontSize', 10)
        
        
        if j == 1
            str = num2str(Phase(i));
            title({str;''}, 'FontWeight', 'bold', 'FontSize', 12)
            if i == 1
%                 cb = colorbar;
%                 cb.Layout.Tile = 'east';
            end
        end
        
        if i == 1
            yticks(0:0.05:0.3)
            ytickformat('%.2f')
        else
            set(gca,'Yticklabel',[])
        end
        
        if j == 3 && i == 1
            ylabel('Intake Port Height Ratio', 'FontSize', 10)
        end
        
        if j == 5
            xticks(0:0.05:0.3)
            xtickformat('%.2f')
        else
            set(gca,'Xticklabel',[])
        end
        
%         str = (sprintf('(%c)',FigureLabels(((j-1)*5)+i)));
        
        if j == 5 && i == 3
            xlabel('Exhaust Port Height Ratio', 'FontSize', 10)
        end
        
        if i == 5
            colorbar
        end

        axis('square')
        
%         hold on
%         [m,index] = min(Mat(:,:,i));
%         [m2,index2] = min(m);
%         x = ExPortH(index2);
%         y = InPortH(index(index2));
%         plot(x,y,'k+','MarkerSize', 15);
%         text(x+0.004,y-0.008,num2str(m2,'%.0f'), 'Color', 'k', 'FontWeight', 'bold', 'FontSize', 10);
%         hold off
    end
end

annotation('textbox', [0.0, 0.87, 0, 0], 'string', 'Delivery Ratio', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.0, 0.69, 0, 0], 'string', 'Trapping Ratio', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.0, 0.51, 0, 0], 'string', 'Charging Efficiency', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.0, 0.335, 0, 0], 'string', 'Scavenging Efficiency', 'FontWeight', 'bold', 'FontSize', 12)
annotation('textbox', [0.0, 0.165, 0, 0], 'string', 'Delta Pressure [bar]', 'FontWeight', 'bold', 'FontSize', 12)

annotation('textbox', [0.02, 0.98, 0, 0], 'string', 'B', 'FontWeight', 'bold', 'FontSize', 20)


